
rem
Encapsulates the logic to do bilinear interpolation
.V1    .V4
.V2    .V3
end rem
Type TBilinearInterpolator

	Field _max:Vector2 = Vector2.Zero()
	Field _min:Vector2 = Vector2.Zero()
	
	Field _value1:Float
	Field _value2:Float
	Field _value3:Float
	Field _value4:Float
	
	Field _maxValue:Float = MathHelper.MaxValueF
	Field _minValue:Float = MathHelper.MinValueF
	
	
	Method GetMin:Vector2()
		Return _min.Copy()		
	End Method
	
	Method SetMin(value:Vector2)
		_min.Set(value)
	End Method
	
	Method GetMax:Vector2()
		Return _max.Copy()
	End Method
	
	Method SetMax(value:Vector2)
		_max.Set(value)
	End Method
	
	Function Create:TBilinearInterpolator(minv:Vector2, maxv:Vector2, value1:Float = 0, value2:Float = 0, value3:Float = 0, value4:Float = 0, minValue:Float = MathHelper.MinValueF, maxValue:Float = Mathhelper.MaxValueF)
		Local bi:TBilinearInterpolator = New TBilinearInterpolator
		bi._min.Set(minv)
		bi._max.Set(maxv)
		bi._value1 = value1
		bi._value2 = value2
		bi._value3 = value3
		bi._value4 = value4
		bi._minValue = minValue
		bi._maxValue = maxValue
		Return bi
	End Function
	
	Method GetValueFromVector:Float(position:Vector2)
		Return GetValue(position.X, position.Y)
	End Method
	
	Method GetValue:Float(x:Float, y:Float)
		Local value:Float
		x = MathHelper.Clamp(x, _min.X, _max.X)
		y = MathHelper.Clamp(y, _min.Y, _max.Y)
		
		Local xRatio:Float = (x - _min.X) / (_max.X - _min.X)
		Local yRatio:Float = (y - _min.Y) / (_max.Y - _min.X)
		
		Local top:Float = MathHelper.Lerp(_value1, _value4, xRatio)
		Local bottom:Float = MathHelper.Lerp(_value2, _value3, xRatio)
		
		value = MathHelper.Lerp(top, bottom, yRatio)
		value = MathHelper.Clamp(value, _minValue, _maxValue)
		Return value
	End Method
End Type
